﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-12 (2012)</title>
		<script runat="server">

		//Wylatują:
		//B11, B12, C7, C8, C13, C15, C17, C18, D6, D7, D13
		//Nowe:    
        //C2    - liczba dni roboczych za październik 2010
        //D2    - liczba dni roboczych za 2010
		//D11   - suma elementów

        //TaskID:16408
        //C2 -> A4
        //D2 -> A5
        //renumeracja od C3..C13 na C2..C12
        //renumeracja od D3..D15 na D2..D14
        //opcja wydruku dla zaznaczonych pracowników
		            
            const string kodPracownika = "";
            static bool debug = false;
		        		    
            class Z12Info : IComparable<Z12Info> {

                readonly Pracownik pracownik;
                readonly PracHistoria historia;
                readonly WykształcenieWg wyksztalcenie;
                readonly int rok;

                public FromTo Październik {
                    get { return new YearMonth(rok, 10).ToFromTo(); }
                }

                public FromTo CałyRok {
                    get { return FromTo.Year(rok); }
                }

                public Z12Info(Pracownik pracownik, int rok, WykształcenieWg wyksztalcenie) {
                    this.pracownik = pracownik;
                    this.rok = rok;
                    this.wyksztalcenie = wyksztalcenie;
                    this.historia = pracownik[Październik.To];
                }
                
                public Pracownik Pracownik {
                    get { return pracownik; }
                }
                
                public object PracownikaKod {
                    get { return pracownik.Kod; }
                }

                public object PracownikaImie {
                    get { return pracownik.Imie; }
                }

                public object PracownikaNazwisko {
                    get { return pracownik.Nazwisko; }
                }
                                
                public int CompareTo(Z12Info other) {
                    return pracownik.Kod.CompareTo(other.pracownik.Kod);
                }

                Periods OkresyZatrudnienia(FromTo okres) {
                    Periods okresy = Periods.Empty;
                    foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
                        if (ph.Etat.EfektywnyOkres != FromTo.Empty && PoprawneZatrudnienie(ph))
                            okresy += ph.Etat.EfektywnyOkres;
                    return (okresy * okres).ToFlat();
                }

                public bool Wchodzi {
                    get {
                        Periods okresy = OkresyZatrudnienia(Październik) * Październik;
                        if (okresy != Październik)
                            return false;
                        //1)
                        if (pracownik[Październik.To].PrawoEmRent.Kod == KodPrawaEmRent.PrawoDoEmerytury && pracownik[Październik.To].PrawoEmRent.EmeryturaOd <= Październik.To)
                            return false;

                        //2)
                        if (!KontrolaNieobecnościNaDni())
                            return false;

                        return true;
                    }
                }

                bool PoprawneZatrudnienie(PracHistoria ph) {
                    return ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.NieDotyczy;
                }

                bool KontrolaNieobecnościNaDni() {
                    int dninie = 0;

                    KalkulatorPracy kalk = pracownik.Czasy.KalkPracy;
                    foreach (OkresNieobecności n in kalk.Nieobecnosci(Październik, true))
                        switch (n.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopBezpłatny:              //2)
                            case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
                                dninie += DniRobocze(n.Okres);
                                break;
                            case PrzyczynaNieobecnosci.UrlopMacierzyński:           //5)
                            case PrzyczynaNieobecnosci.UrlopWychowawczy:
                            case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                            //UrlopProfilaktycny
                                return false;
                        }

                    foreach (WypElement e in pracownik.Elementy[Październik]) {
                        Nieobecnosc n = e.BazaZrodla as Nieobecnosc;
                        if (n != null && n.Definicja.Przyczyna == PrzyczynaNieobecnosci.ZwolnienieChorobowe) {
                            int d = DniRobocze(e.Okres);
                            if (d > 0) {
                                if (e.ZasiłekZus)                                   //3)
                                    return false;
                                dninie += d;
                            }
                        }
                    }

                    return dninie<=10;                
                }

                public int DniRoboczeDlaJednostki(FromTo okres) {
                    return DniRobocze(okres);
                }
                
                public int DniRobocze(FromTo okres) {
                    int c = 0;
                    foreach (Date d in okres)
                        switch (d.DayOfWeek) {
                            case DayOfWeek.Saturday:
                                if (Kalendarz.DzieńŚwiąteczny(d) && d.Year<=2010)
                                    c--;
                                break;
                            case DayOfWeek.Sunday:
                                break;
                            default:
                                if (!Kalendarz.DzieńŚwiąteczny(d))
                                    c++;
                                break;
                        }
                    return c;
                }

                public Time CzasOpłaconyNominalny(FromTo okres) {
                    Time nominalny, pomniejszenia, plus, minus;
                    LiczCzas(okres, out nominalny, out pomniejszenia, out plus, out minus);
                    Time odchyłki = Time.Min(plus + minus, Time.Zero);
                    return nominalny + pomniejszenia + odchyłki;
                }

                public Time CzasOpłaconyNadgodziny(FromTo okres) {
                    Time nominalny, pomniejszenia, plus, minus;
                    LiczCzas(okres, out nominalny, out pomniejszenia, out plus, out minus);
                    Time odchyłki = Time.Max(plus + minus, Time.Zero);
                    return odchyłki;
                }
                                                
                //------------------- GRUPA B ----------------------

                public string KodWykonywanegoZawodu {   //B3
                    get {
                        string s = historia.Etat.KodWykonywanegoZawodu.ToString();
                        if (s == "0")
                            s = "";
                        else if (s.Length > 6)
                            s = s.Substring(0, 6);
                        return s;
                    }
                }

                public int Płeć {                       //B4
                    get { return historia.Plec == PłećOsoby.Kobieta ? 2 : 1; }
                }

                public int PoziomWyksztalcenia2 {
                    get {
                        switch (historia.Wyksztalcenie.Kod) {
                            //1.wyższe doktor (brak)
                            case KodWyksztalcenia.WyższeZeStopiemNaukowym:
                                return 1;
                            //2.wyższe magister
                            case KodWyksztalcenia.Wyzsze:
                                return 2;
                            //3.licencjat
                            case KodWyksztalcenia.Licencjat:
                                return 3;
                            //4.policealne
                            case KodWyksztalcenia.Policealne:
                                return 4;
                            //5.średnie zawodowe
                            case KodWyksztalcenia.SrednieZawodowe:
                                return 5;
                            //6.średnie ogólnokształcące
                            case KodWyksztalcenia.SrednieOgolnoksztalcace:
                                return 6;
                            //7.zasadnicze zawodowe
                            case KodWyksztalcenia.ZasadniczeZawodowe:
                                return 7;
                            //8.gimnazjalne
                            case KodWyksztalcenia.Gimnazjalne:
                                return 8;
                            //9.podstawowe i niepełne podstawowe
                            case KodWyksztalcenia.NiepelnePodstawowe:
                            case KodWyksztalcenia.Podstawowe:
                                return 9;
                        }
                        return 0;
                    }
                }
                
                public int PoziomWyksztalcenia1 {
                    get {
                        switch (historia.GUS.KodWyksztalcenia) {
                            //1.wyższe doktor (brak)
                            case KodWykształceniaGUS.WyższeZeStopiemNaukowym:
                                return 1;
                            //2.wyższe magister
                            case KodWykształceniaGUS.Wyższe:
                                return 2;
                            //3.licencjat
                            case KodWykształceniaGUS.WyższeZawodowe:
                                return 3;
                            //4.policealne
                            case KodWykształceniaGUS.Policealne:
                                return 4;
                            //5.średnie zawodowe
                            case KodWykształceniaGUS.ŚrednieZawodowe:
                                return 5;
                            //6.średnie ogólnokształcące
                            case KodWykształceniaGUS.ŚrednieOgólnokształcące:
                                return 6;
                            //7.zasadnicze zawodowe
                            case KodWykształceniaGUS.ZasadniczeZawodowe:
                                return 7;
                            //8.gimnazjalne
                            case KodWykształceniaGUS.Gimnazjalne:
                                return 8;
                            //9.podstawowe i niepełne podstawowe
                            case KodWykształceniaGUS.PodstawoweINiepełnePodstawowe:
                                return 9;
                        }
                        return 0;
                    }
                }

                public object PoziomWyksztalcenia {      //B5
                    get { return wyksztalcenie == WykształcenieWg.KodWykształcenia ? PoziomWyksztalcenia2 : PoziomWyksztalcenia1; }
                }

                public object RodzajUmowyOPracę {          //B6
                    get {
                        switch (historia.Etat.TypUmowy) {
                            case TypUmowyOPrace.NaCzasNieokreślony:
                                return 1;
                            case TypUmowyOPrace.NaCzasOkreślony:
                                return 2;
                            case TypUmowyOPrace.NaOkresPróbny:
                                return 4;
                        }
                        return 3;
                    }
                }

                public object SystemCzasuPracy {        //B7 ???
                    get { return 0; }
                }
                
                public string RokUrodzenia {               //B8
                    get {
                        Date data = historia.Urodzony.Data;
                        return string.Format("{0}.{1:00}", data.Year % 100, data.Month); 
                    }
                }

                public object StażPracyOgółem {         //B9
                    get { return StażPracy(pracownik.StażPracy(Październik.To, pracownik.Module.DefPodstawStazu.Zatrudnienie)); }
                }

                public object StażPracyWFirmie {       //B10
                    get { return StażPracy (pracownik.StażPracy (Październik.To)); }
                }

                //------------------- GRUPA C ----------------------

                public object WskaźnikWymiaruCzasuPracy10 {                   //C1
                    get {
                        int dd = DniRobocze(Październik);
                        decimal wskaźnik = WskaźnikWymiaruCzasuPracy(Październik);
                        wskaźnik = Soneta.Tools.Math.RoundCy(wskaźnik * 1m / dd);
                        return wskaźnik.ToString().Replace(',', '.');
                    }
                }

                public decimal DniRobocze10 {                                   //A4
                    get { return DniRoboczeDlaJednostki(Październik); }
                }

                public object TygodniowaNormaCzasuPracy10 {                     //C2
                    get {
                        Kalendarz k = historia.Etat.Kalendarz;
                        if (k == null)
                            return "?";
                        //return Czas(k.NormaDobowa * (historia.Etat.Zaszeregowanie.Wymiar * 5));
                        return Czas(k.NormaDobowa * 5.0);
                    }
                }

                public object CzasOpłaconyNominalny10 {                 //C3
                    get { return Czas(CzasOpłaconyNominalny(Październik)); }
                }

                public object CzasOpłaconyNadgodziny10 {                //C4
                    get { return Czas(CzasOpłaconyNadgodziny(Październik)); }
                }

                //------------------- GRUPA D ----------------------
                public decimal WskaźnikWymiaruCzasuPracyRok {           //D1
                    get {
                        int dd = DniRobocze(CałyRok);
                        Periods okresy = OkresyZatrudnienia(CałyRok);
                        okresy = okresy.BreakByMonth();
                        decimal wskaźnik = 0m;
                        foreach (FromTo okres in okresy)
                            wskaźnik += WskaźnikWymiaruCzasuPracy(okres);
                        wskaźnik = Soneta.Tools.Math.RoundCy(wskaźnik * 12m / dd);
                        return wskaźnik;
                    }
                }

                public decimal DniRoboczeRok {                          //A5
                    get { return DniRoboczeDlaJednostki(CałyRok); }
                }
                
                public object CzasOpłaconyRazemRok {                    //D2
                    get {
                        Periods okresy = Periods.New(CałyRok).BreakByMonth();
                        Time czas = Time.Zero;
                        foreach (FromTo okres in okresy)
                            czas += CzasOpłaconyNominalny(okres);
                        return Czas(czas);
                    }
                }

                public object CzasOpłaconyNadgodzinyRok {                //D3
                    get {
                        Periods okresy = Periods.New(CałyRok).BreakByMonth();
                        Time czas = Time.Zero;
                        foreach (FromTo okres in okresy)
                            czas += CzasOpłaconyNadgodziny(okres);
                        return Czas(czas);
                    }
                }
                
                //------------------- TOOLS ------------------------

                void LiczCzas(FromTo okres, out Time nominalny, out Time pomniejszenia, out Time plus, out Time minus) {
                    nominalny = Time.Zero;
                    pomniejszenia = Time.Zero;
                    plus = Time.Zero;
                    minus = Time.Zero;

                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element is WypElementEtat || element is WypElementNadgodziny.Odchyłki)
                            foreach (WypSkladnik składnik in element.Skladniki)
                                switch (składnik.Rodzaj) {
                                    case RodzajSkładnikaWypłaty.Główny:
                                        nominalny += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.Korekta:
                                        break;
                                    case RodzajSkładnikaWypłaty.PomniejszenieProp:
                                    case RodzajSkładnikaWypłaty.Pomniejszenie130:
                                    case RodzajSkładnikaWypłaty.PomniejszenieZaDzień:
                                    case RodzajSkładnikaWypłaty.PomniejszeniePropZero:
                                        pomniejszenia += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.PomniejszenieStorno:
                                        break;
                                    case RodzajSkładnikaWypłaty.OdchyłkaPlus:
                                        plus += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.OdchyłkaMinus:
                                        minus += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.OdchyłkaAkordMinus:
                                        break;
                                }
                }

                public decimal SumaElementów(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    decimal wartość = 0;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1)
                            wartość += element.Wartosc;
                    return wartość;
                }

                public decimal SumaOdchyłekPlus(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    decimal wartość = 0;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1)
                            foreach (WypSkladnik skl in element.Skladniki)
                                if (skl is WypSkladnikOdchyłka.Plus)
                                    wartość += skl.Wartosc;
                    return wartość;
                }

                public Time SumaCzasuElementów(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    Time czas = Time.Zero;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1) {
                            Time c = element.Czas;
                            if (c == Time.Zero)
                                czas += pracownik.Czasy.Norma(element.Okres).Czas;
                            else
                                czas += element.Czas;
                        }
                    return czas;
                }
                
                public int SumaDniElementów(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    int dni = 0;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1)
                            dni += element.Dni;
                    return dni;
                }
                                
                public Time CzasNieprzepracowany(FromTo okres, string pozycja) {
                    if (pozycja!="")
                        pozycja = pozycja + "|";
                    Time czas = Time.Zero;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element is WypElementEtat  || element is WypElementNadgodziny.Odchyłki)
                            foreach (WypSkladnik składnik in element.Skladniki) {
                                WypSkladnikPomniejszenie skłpomn = składnik as WypSkladnikPomniejszenie;
                                Nieobecnosc nieobecność = skłpomn == null ? null : skłpomn.Nieobecnosc;
                                if (nieobecność != null && (pozycja=="" || nieobecność.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1))
                                    czas += skłpomn.Czas;
                                if (składnik is WypSkladnikOdchyłka.Minus)
                                    czas += składnik.Czas;
                            }
                    return -czas;
                }
                
                public Time CzasNieprzepracowanyZero(FromTo okres, string pozycja) {
                    Time czas = Time.Zero;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element is WypElementEtat)
                            foreach (WypSkladnik składnik in element.Skladniki) {
                                if (składnik.Rodzaj != RodzajSkładnikaWypłaty.PomniejszeniePropZero)
                                    continue;
                                WypSkladnikPomniejszenie skłpomn = składnik as WypSkladnikPomniejszenie;
                                Nieobecnosc nieobecność = skłpomn == null ? null : skłpomn.Nieobecnosc;
                                if (nieobecność != null)
                                    czas += skłpomn.Czas;
                            }
                    return -czas;
                }

                public int DniNieprzepracowaneZero(FromTo okres, string pozycja) {
                    int dni = 0;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element is WypElementEtat)
                            foreach (WypSkladnik składnik in element.Skladniki) {
                                if (składnik.Rodzaj != RodzajSkładnikaWypłaty.PomniejszeniePropZero)
                                    continue;
                                WypSkladnikPomniejszenie skłpomn = składnik as WypSkladnikPomniejszenie;
                                Nieobecnosc nieobecność = skłpomn == null ? null : skłpomn.Nieobecnosc;
                                if (nieobecność != null)
                                    dni += skłpomn.Dni;
                            }
                    return -dni;
                }
                                
                decimal WskaźnikWymiaruCzasuPracy(FromTo okres) {
                    Fraction wymiar = Fraction.Zero;
                    foreach (PracHistoria ph in Pracownik.Historia.GetIntersectedRows(okres)) {
                        int d = DniRobocze(ph.Etat.EfektywnyOkres * okres);
                        Fraction w = ph.Etat.Zaszeregowanie.Wymiar;
                        w *= new Fraction(d, 1);
                        wymiar += w;
                    }
                    return Soneta.Tools.Math.Round((decimal)wymiar, 2);
                }                
            }

    public enum WykształcenieWg {
        PoziomUkończonegoWykształcenia,
        KodWykształcenia
    }
            
    public class SrParams : SerializableContextBase {
        
        public SrParams(Context context) : base(context) {
        }

        bool wgListy = false;
        [Priority(1)]
        [Caption("Pracownicy wg listy")]
        public bool WgListy {
            get { return wgListy; }
            set {
                wgListy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        WykształcenieWg wyksztalcenie = WykształcenieWg.KodWykształcenia;
        [Priority(2)]
        [Caption("Wykształcenie wg")]
        public WykształcenieWg Wyksztalcenie {
            get { return wyksztalcenie; }
            set {
                wyksztalcenie = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }	            
                            
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year - 1;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

            void dc_ContextLoad(Object sender, EventArgs e) {
                Log log = new Log();
                ReportHeader["ROK"] = pars.Rok.ToString();

                List<Z12Info> lista = new List<Z12Info>();
                IEnumerable st;

                if (srpars.WgListy) {
                    ArrayList lst = new ArrayList();
                    foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                        lst.Add(idx);
                    st = lst;
                }
                else
                    st = KadryModule.GetInstance(dc).Pracownicy.WgKodu;
                
                int c = 0;
                foreach (Pracownik pracownik in st)
                    c++;
                
                int l = 0;
                foreach (Pracownik pracownik in st)
                    if (kodPracownika == "" || pracownik.Kod == kodPracownika) {
                        log.WriteLine(pracownik);
                        log.WriteLine(new Percent(l++, c));
                        Z12Info z12info = new Z12Info(pracownik, pars.Rok, srpars.Wyksztalcenie);
                        if (z12info.Wchodzi)
                            lista.Add(z12info);
                    }

                lista.Sort();

                Grid1.DataSource = lista;
            }

            public static object StażPracy(StazPracy stp) {
                stp = stp.Normalizuj();
                if (debug)
                    return stp;
                return string.Format("{0}.{1:00}", stp.Lata, stp.Miesiace);
            }

            public static object Czas(Time t) {
                return Czas(t, 2);
            }		    
		    
            public static object Czas(Time t, int precyzja) {
                if (debug)
                    return t;
                return Soneta.Tools.Math.Round(t.TotalHours, precyzja);
            }

            public decimal Tys(decimal value) {
                if (debug)
                    return value;
                return Soneta.Tools.Math.Round(value / 1000m, 1);
            }


            static void Msg(object value) {
            }

            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Z12Info info = (Z12Info)args.Row;

                c5.EditValue = Czas(info.CzasNieprzepracowany(info.Październik, "C5") + info.SumaCzasuElementów(info.Październik, "C5") + info.CzasNieprzepracowanyZero(info.Październik, ""));
                c6.EditValue = Czas(info.SumaCzasuElementów(info.Październik, "C6") + info.CzasNieprzepracowanyZero(info.Październik, ""));
                                                
                decimal v8, v11, v12;

                c8.EditValue = v8 = info.SumaElementów(info.Październik, "C8") - info.SumaOdchyłekPlus(info.Październik, "C8");
                c9.EditValue = info.SumaElementów(info.Październik, "C9") - info.SumaOdchyłekPlus(info.Październik, "C9");
                c10.EditValue = info.SumaElementów(info.Październik, "C10");
                c11.EditValue = info.SumaElementów(info.Październik, "C11");
                c12.EditValue = v12 = info.SumaElementów(info.Październik, "C12") + info.SumaOdchyłekPlus(info.Październik, "C8");

                c7.EditValue = v8 + v12;

                d4.EditValue = Czas(info.CzasNieprzepracowany(info.CałyRok, "D4") + info.SumaCzasuElementów(info.CałyRok, "D4") + info.CzasNieprzepracowanyZero(info.CałyRok, ""));
                d5.EditValue = Czas(info.SumaCzasuElementów(info.CałyRok, "D5") + info.CzasNieprzepracowanyZero(info.CałyRok, ""));
                
                d6.EditValue = info.SumaDniElementów(info.CałyRok, "D6") + info.DniNieprzepracowaneZero(info.CałyRok, "");

                d8.EditValue = v8 = info.SumaElementów(info.CałyRok, "D8") - info.SumaOdchyłekPlus(info.CałyRok, "D8");
                d9.EditValue = info.SumaElementów(info.CałyRok, "D9");
                d10.EditValue = info.SumaElementów(info.CałyRok, "D10");
                d11.EditValue = v11 = info.SumaElementów(info.CałyRok, "D11") + info.SumaOdchyłekPlus(info.CałyRok, "D8");
                d12.EditValue = info.SumaElementów(info.CałyRok, "D12");
                d13.EditValue = info.SumaElementów(info.CałyRok, "D13");
                d14.EditValue = info.SumaElementów(info.CałyRok, "D14");

                d7.EditValue = v8 + v11;                
            }
</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
				<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad" 
                    style="top: 0px" Landscape="True"></ea:DataContext>
				<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS Z-12|</strong>Rok: <strong>%ROK%"
					runat="server"></eb:ReportHeader>
        <ea:Grid id="Grid1" runat="server" Sort="Pracownik.NazwiskoImię,Nazwa" 
                    onbeforerow="Grid1_BeforeRow">
            <Columns>
                <ea:GridColumn Width="3" Align="Right" DataMember="#" Caption="Lp." 
                    runat="server"></ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Kod" DataMember="PracownikaKod" 
                    Width="12" ColSpan="3" Format="&lt;strong&gt;{0}&lt;/strong&gt;">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Imię" DataMember="PracownikaImie" 
                    ColSpan="3" Format="&lt;strong&gt;{0}&lt;/strong&gt;">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Nazwisko Pracownika" 
                    DataMember="PracownikaNazwisko" ColSpan="6" 
                    Format="&lt;strong&gt;{0}&lt;/strong&gt;">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="A4" HideZero="True" Align="Right"
                    DataMember="DniRobocze10">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="A5" HideZero="True" Align="Right" 
                    DataMember="DniRoboczeRok">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B1" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B2" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B3" DataMember="KodWykonywanegoZawodu" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B4" DataMember="Płeć" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B5" DataMember="PoziomWyksztalcenia" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B6" DataMember="RodzajUmowyOPracę" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B7" DataMember="SystemCzasuPracy" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B8" DataMember="RokUrodzenia" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B9" DataMember="StażPracyOgółem" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B10" DataMember="StażPracyWFirmie" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C1" 
                    DataMember="WskaźnikWymiaruCzasuPracy10" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C2" 
                    DataMember="TygodniowaNormaCzasuPracy10" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C3" DataMember="CzasOpłaconyNominalny10" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C4" 
                    DataMember="CzasOpłaconyNadgodziny10" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C5" ID="c5" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C6" ID="c6" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C7" ID="c7" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn ID="c8" runat="server" Caption="C8" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn ID="c9" runat="server" Caption="C9" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn ID="c10" runat="server" Caption="C10" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn ID="c11" runat="server" Caption="C11" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn ID="c12" runat="server" Caption="C12" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D1" 
                    DataMember="WskaźnikWymiaruCzasuPracyRok" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D2" DataMember="CzasOpłaconyRazemRok" 
                    HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D3" 
                    DataMember="CzasOpłaconyNadgodzinyRok" HideZero="True" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D4" ID="d4" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D5" ID="d5" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D6" ID="d6" HideZero="True" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D7" HideZero="True" ID="d7" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D8" HideZero="True" ID="d8" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D9" HideZero="True" ID="d9" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D10" HideZero="True" ID="d10" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D11" HideZero="True" ID="d11" 
                    Align="Right">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D12" ID="d12" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D13" ID="d13" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D14" ID="d14" Align="Right" 
                    HideZero="True">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
				<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>
